﻿///
/// アーカイブボリュームの列挙実装クラス ArchiveEnumeratorImpl のヘッダファイル。
/// Internal: 非公開ヘッダファイル。
///

#if       !defined(INCLUDED_SZ_ARCHIVE_ENUMERATOR_IMPL)
#define            INCLUDED_SZ_ARCHIVE_ENUMERATOR_IMPL

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

#if       !defined(INCLUDED_SZ_FILE_PROPERTY_INFO)
#include  "szFilePropertyInfo.hpp"
#endif // !defined(INCLUDED_SZ_FILE_PROPERTY_INFO)

#include  <Common/MyCom.h>
#include  <7zip/Archive/IArchive.h>
#ifndef _NO_CRYPTO
#include  <7zip/IPassword.h>
#endif

SZ_NS_BEG(szpp)

/// <summary>
/// アーカイブデータの格納ファイルの列挙を実装するクラス。
/// </summary>
/// <notes>
/// クライアントが 7-Zip ヘッダを参照しなくて良いように、実装詳細は完全にこのクラスに分離してある。
/// </notes>
class SZ_SPEC ArchiveEnumeratorImpl :
  public IArchiveOpenCallback,
  public IArchiveOpenVolumeCallback,
  public IArchiveOpenSetSubArchiveName,
#ifndef _NO_CRYPTO
  public ICryptoGetTextPassword,
#endif
  public CMyUnknownImp
{
public:

  ArchiveEnumeratorImpl(ArchiveVolume *volume, u64 searchLimitSize, ArchiveOpenClientCallback *open, GetPasswordClientCallback *pwd);
  ~ArchiveEnumeratorImpl();

  ArchiveContent *EnumerateUnknown(ArchiveHandler **handler);
  ArchiveContent *Enumerate(const ArchiveHandler *handler);
  
  static ArchiveContent *EnumerateUnknown(ArchiveHandler **handler, ArchiveVolume *volume, u64 searchLimitSize, ArchiveOpenClientCallback *open, GetPasswordClientCallback *pwd);
  static ArchiveContent *Enumerate(const ArchiveHandler *handler, ArchiveVolume *volume, u64 searchLimitSize, ArchiveOpenClientCallback *open, GetPasswordClientCallback *pwd);

#pragma region 7-Zip インターフェース実装

#ifndef _NO_CRYPTO
  MY_UNKNOWN_IMP3(
      IArchiveOpenVolumeCallback,
      IArchiveOpenSetSubArchiveName,
      ICryptoGetTextPassword
      )
#else
  MY_UNKNOWN_IMP2(
      IArchiveOpenVolumeCallback,
      IArchiveOpenSetSubArchiveName
      )
#endif

  STDMETHOD(SetTotal)(const UInt64 *files, const UInt64 *bytes);
  STDMETHOD(SetCompleted)(const UInt64 *files, const UInt64 *bytes);

  STDMETHOD(GetProperty)(PROPID propID, PROPVARIANT *value);
  STDMETHOD(GetStream)(const wchar_t *name, IInStream **inStream);

  STDMETHOD(SetSubArchiveName(const wchar_t *name));

#ifndef _NO_CRYPTO
  STDMETHOD(CryptoGetTextPassword)(BSTR *password);
#endif

#pragma endregion

private:

  StoredItem *CreateStoredItem(index_t index);
  void FillArchiveProperty(ArchiveProperty *archiveProperty);

  ArchiveVolume *volume;
  u64 searchLimitSize;
  ArchiveOpenClientCallback *openCallback;
  GetPasswordClientCallback *pwdCallback;

  FilePropertyInfo filePropertyInfo;

  // 現在は Enumerate 内部でしか使っていないが、万が一コールバック内で使いたくなった場合のために、ローカル変数ではなくフィールドにしてある。
  CMyComPtr<IInArchive> archive;
};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_ENUMERATOR_IMPL)
